\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{ub}

%Option declaration

\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions\relax
\LoadClass{article}


% Encoding
\RequirePackage[T1]{fontenc}
\RequirePackage[utf8]{inputenc}
% Nicer math
\RequirePackage{upgreek}
\RequirePackage{amsmath}
\RequirePackage{amsfonts}
\RequirePackage{amssymb}
% Colour and graphics
\RequirePackage{color}
\RequirePackage{graphicx}

% Page layout / look and feel
\RequirePackage[a4paper]{geometry}
\RequirePackage[bottom]{footmisc}
\RequirePackage{pdflscape}

%Tables
\RequirePackage{xtab}
\RequirePackage{longtable}
\RequirePackage{booktabs}
\RequirePackage{multicol}
\RequirePackage{multirow}

% Declarations
\def\@laa{MeinName}
\def\@laastreet{MeineStraße}
\def\@laacity{MeineStadt,PLZ}
\def\@sps{MeinSeminar}
\def\@fach{}
\def\@klasse{}
\def\@kurs{}
\def\@thema{}
\def\@datum{}
\def\@stunde{}
\def\@von{}
\def\@bis{}
\def\@raum{}
\def\@etage{}
\def\@schuladresse{Adresse Schule}
\def\@hsleitung{}
\def\@fsleitung{}
\def\@sleitung{}
\def\@wievielter{}
% Definitions

\newcommand{\laa}[1]{\def\@laa{#1}}
\newcommand{\laastreet}[1]{\def\@laastreet{#1}}
\newcommand{\laacity}[1]{\def\@laacity{#1}}
\newcommand{\sps}[1]{\def\@sps{#1}}
\newcommand{\fach}[1]{\def\@fach{#1}}
\newcommand{\klasse}[1]{\def\@klasse{#1}}
\newcommand{\kurs}[1]{\def\@kurs{#1}}
\newcommand{\thema}[1]{\def\@thema{#1}}
\newcommand{\datum}[1]{\def\@datum{#1}}
\newcommand{\stunde}[1]{\def\@stunde{#1}}
\newcommand{\von}[1]{\def\@von{#1}}
\newcommand{\bis}[1]{\def\@bis{#1}}
\newcommand{\raum}[1]{\def\@raum{#1}}
\newcommand{\etage}[1]{\def\@etage{#1}}
\newcommand{\schuladresse}[1]{\def\@schuladresse{#1}}
\newcommand{\hsleitung}[1]{\def\@hsleitung{#1}}
\newcommand{\fsleitung}[1]{\def\@fsleitung{#1}}
\newcommand{\sleitung}[1]{\def\@sleitung{#1}}
\newcommand{\wievielter}[1]{\def\@wievielter{#1}}


% Lengths and utilities
\newcommand{\tlbreak}{\par\vskip 0.5\baselineskip}
\newcommand{\absatz}{\\[0.5\baselineskip]}
\newcommand{\namealign}[1]{\makebox[3.5cm][l]{#1}}
\newlength{\parindentstore}
\setlength{\parindentstore}{\parindent}
\newcommand{\tabbreak}{\\}
\newcommand{\multic}[1]{\multicolumn{1}{c}{#1}}
\newcommand{\multicbf}[1]{\multicolumn{1}{c}{\textbf{#1}}}
\newcommand{\multilbf}[1]{\multicolumn{1}{l}{\textbf{#1}}}

% Titlepage
\newcommand\titelblatt{%
	\thispagestyle{empty}
	\setlength\parindent{0pt}
		\@laa\par
		\@laastreet\par
		\@laacity\par
		\vskip 1\baselineskip
		\@sps
		\vskip -3.5\baselineskip
		\vskip 0.2\textheight
		\begin{center}
			{\huge Unterrichtsentwurf für das Fach \@fach \vskip\baselineskip}
			{\LARGE \@thema}
		\end{center}
		\vskip 0.15\textheight
		{\@fach , \@klasse , \@kurs\tlbreak}
		{\@datum , \@stunde Stunde (\@von -- \@bis), Raum \@raum, \@etage Etage\tlbreak}
		{\@schuladresse}
		\vfill
		{\namealign{Hauptseminarleitung:} \@hsleitung\tlbreak}
		{\namealign{Fachtseminarleitung:} \@fsleitung\tlbreak}
		{\namealign{Schulleitung:} \@sleitung\tlbreak}
		\vskip 2.5\baselineskip
		{\@wievielter Unterrichtsbesuch im Fach \@fach}
	\setlength\parindent{\parindentstore}
	\restoregeometry
\clearpage
\setcounter{page}{1}
}


%%%% Tables
%UB-Stand
\def\@standeinleitung{}
	\newcommand{\standeinleitung}[1]{\def\@standeinleitung{#1 \par\vskip 1.5\baselineskip}}

\def\@standheader{%
	\textbf{UB}	& \textbf{Datum}	& \textbf{Fach}	& \textbf{Klasse}	& \textbf{Thema}	& \multicbf{HSL}	& \multicbf{FSL}		& \multicbf{SL}
}
\newcommand{\standzeile}[8]{%
	#1 & #2 & #3 & #4 & #5 & \multic{#6} & \multic{#7} & \multic{#8} \\
}

\newcommand{\ubstand}[1]{%
\renewcommand{\arraystretch}{1.5}
	\@standeinleitung
	\noindent
	\begin{xtabular}{
					@{} 	p{\dimexpr 0.05\linewidth  - \tabcolsep}
						p{\dimexpr 0.15\linewidth  -2\tabcolsep}
						p{\dimexpr 0.11\linewidth  -2\tabcolsep}
						p{\dimexpr 0.1\linewidth  -2\tabcolsep}
						p{\dimexpr 0.41\linewidth  -2\tabcolsep}
						p{\dimexpr 0.06\linewidth  -2\tabcolsep}
						p{\dimexpr 0.06\linewidth  -2\tabcolsep}
						p{\dimexpr 0.06\linewidth  - \tabcolsep} @{}}
	\toprule
	\@standheader \\ \midrule
	\input{#1} \bottomrule
	\end{xtabular}
\renewcommand{\arraystretch}{1}
}

%Thema
\def\@themaheader{%
	\multicolumn{2}{c}{\textbf{Stunde}} 	& \multicbf{Thema der Stunde}	 & \multicbf{Standards laut RLP} & \multicbf{Abschlusstandard der Stunde}                                                                                                                                                                }
\def\@themaeinleitung{}
	\newcommand{\themaeinleitung}[1]{\def\@themaeinleitung{#1 \par\vskip 1.5\baselineskip}}
\def\@lek{}
	\newcommand{\lek}[2]{#1 & #2 & \multicolumn{3}{c}{Lernerfolgskontrolle}}
\def\@diesestunde{}
	\newcommand{\diesestunde}[5]{\textbf{#1} & \textbf{#2} & \textbf{#3} & \textbf{#4}	& \textbf{#5}}

\newcommand{\unterrichtseinheit}[1]{%
\renewcommand{\arraystretch}{1.5}
	\@themaeinleitung 
	\noindent
	\begin{xtabular}{
					@{} p{\dimexpr 0.02\linewidth - \tabcolsep}
						p{\dimexpr 0.13\linewidth -2\tabcolsep}
						p{\dimexpr 0.32\linewidth -2\tabcolsep}
						p{\dimexpr 0.22\linewidth -2\tabcolsep}
						p{\dimexpr 0.31\linewidth - \tabcolsep} @{}}
		\toprule
		\@themaheader \\ \midrule
		\input{#1} \bottomrule
	\end{xtabular}
\renewcommand{\arraystretch}{1}
}


%Kompetenzen
\def\@kompheader{%
	\multicbf{Rahmenlehrplan} & \multicbf{Stand der Lerngruppe} & \multicbf{Standardkonkretisierung}
}

\def\@kompeinleitung{}
	\newcommand{\kompeinleitung}[1]{\def\@kompeinleitung{#1 \par\vskip 1.5\baselineskip}}

\newcommand{\kompsubheader}[1]{%
	\textit{#1:}			& 						& \\
	die Lernenden\dots	& die Lernenden\dots		& die Lernenden\dots
}

\newcommand{\kompetenzen}[1]{%
	\@kompeinleitung	
	\noindent
	\renewcommand{\arraystretch}{1.5}
	\begin{xtabular}{
					@{}	p{\dimexpr  0.25\linewidth - \tabcolsep}
						p{\dimexpr 0.375\linewidth -2\tabcolsep}
						p{\dimexpr 0.375\linewidth - \tabcolsep} @{}}
		\toprule
		\@kompheader	 \\ \midrule
		\input{#1} \bottomrule
	\end{xtabular}
\renewcommand{\arraystretch}{1}	
}


%Ablauf
\def\@ablaufeinleitung{}
	\newcommand{\ablaufeinleitung}[1]{\def\@ablaufeinleitung{#1 \par\vskip 1.5\baselineskip}}

\def\@ablaufheader{%
	\textbf{Lehrerverhalten \&} \textbf{Impulse} & \textbf{Antizipiertes} \textbf{SuS-Verhalten}	& \textbf{Sozialformen \&}\textbf{ Medien} & \textbf{Kompetenz-}\textbf{bezug}
}

\newcommand{\phase}[2]{%
	\midrule \multicolumn{1}{l}{\textbf{#1}} & \multicolumn{3}{l}{\textbf{#2}}
}
\newcommand{\einstieg}[1]{%
	\\ \midrule \multicolumn{1}{l}{\textbf{#1}} & \multicolumn{3}{l}{\textbf{Einstieg}}
}

\newcommand{\ablaufzeile}[4]{%
	#1 & #2 & #3 & #4 \tabbreak
}

\newcommand{\ablauf}[1]{%
	\@ablaufeinleitung
	\noindent
	\renewcommand{\arraystretch}{1.5}
	\begin{xtabular}{
					@{}	p{\dimexpr 0.35\linewidth - \tabcolsep}
						p{\dimexpr 0.35\linewidth -2\tabcolsep}
						p{\dimexpr 0.15\linewidth -2\tabcolsep}
						p{\dimexpr 0.15\linewidth - \tabcolsep} @{}}
		\toprule
		\@ablaufheader	 
		\input{#1} \bottomrule
	\end{xtabular}
\renewcommand{\arraystretch}{1}

}


% Unterschrift
\def\@unterschrift{}
\newcommand{\unterschrift}{%
	\vskip 15\baselineskip
	\hrulefill
	\vskip 0.5\baselineskip
	Ort, Datum \hspace{0.5\linewidth}\@laa
\newpage
}


\endinput